#include "StateManager.h"

StateManager* StateManager::Instance = 0;

StateManager* StateManager::getInstance()
{
	if (Instance == 0)
		Instance = new StateManager();
	return Instance;
}

StateManager::StateManager()
{
}

StateManager::~StateManager()
{
	delete Instance;
}

void StateManager::Init()
{
	if (!ListStateGame.empty())
		ListStateGame.back()->Init();
}

void StateManager::addStateGame(StateGame* state)
{
	if (!ListStateGame.empty())
	{
		ListStateGame.back()->PauseGame();
	}
	ListStateGame.push_back(state);
	ListStateGame.back()->Init();
}

void StateManager::removeStateGame()
{
	if (!ListStateGame.empty())
		ListStateGame.pop_back();
}

void StateManager::clearStates()
{
	while (!ListStateGame.empty())
	{
		ListStateGame.pop_back();
	}
}

void StateManager::Update()
{
	if (!ListStateGame.empty())
		ListStateGame.back()->Update();
}

void StateManager::Draw()
{
	if (!ListStateGame.empty())
		ListStateGame.back()->Draw();
}

void StateManager::Pause()
{
	if (!ListStateGame.empty())
		ListStateGame.back()->PauseGame();
}

void StateManager::Resume()
{
	if (!ListStateGame.empty())
		ListStateGame.back()->ResumeGame();
}